@extends('backend.layouts.master')

@section('title')
    Headline
@endsection

@section('css')
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
@endsection

@section('back-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">Top 10 Deposit User</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">All Headline</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-7 col-7">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">All Headline</h3>
                        </div>
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th>Title</th>
                                        <th width="10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($headlines as $key => $headline)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $headline->title }}</td>
                                            <td>
                                                <button  type="button" onclick="deleteData({{ $headline->id }})" class="btn btn-danger btn-sm">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                <form id="delete-form-{{ $headline->id }}" action="{{ route('admin.top-deposit-user-headline.delete', $headline->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 col-5">
                    <form action="{{ route('admin.top-deposit-user-headline.store') }}" method="POST">
                        @csrf
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">New headline</h3>
                            </div>
                            <div class="card-body row">
                                <div class="form-group col-lg-12 col-md-12 col-12">
                                    <label for="title">Title</label>
                                    <textarea class="form-control" name="title" id="title" cols="30" rows="4" required></textarea>
                                </div>

                                <div class="form-group col-lg-12 col-md-12 col-12">
                                    <label for="headline_link">Link</label>
                                    <input type="text" class="form-control" id="headline_link" name="link" value="#" placeholder="Link">
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
                
                <table class="table table-bordered text-nowrap table-no-vertical-border table-flush" id="example1">
                <thead class="thead-light">
                    <tr>
                        <th scope="col border-bottom-0">RANK</th>
                        <th scope="col border-bottom-0">ID</th>
                        <th scope="col border-bottom-0">USER NAME</th>
                        <th scope="col border-bottom-0">AMOUNT</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($top_users as $key => $data)
                            <tr>
                                <td>{{ $key + 1 }}</td> <!-- Increment rank with each row -->
                                <td>{{ user_code($data->user_id) }}</td>
                                <td>{{ user_name($data['user_id']) }}</td>
                                <td>$ {{ number_format($data['total_amount'], 2) }}</td>
                            </tr>
                    @endforeach
                </tbody>
            </table>
                
            </div>
    </section>
@endsection

@section('js')
    <script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>

    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });

        function deleteData(id) {
            if (confirm("Are you sure?")) {
                document.getElementById('delete-form-'+id).submit();
            }
            return false;
        }
    </script>
@endsection
